@extends('layouts.app')

@php
    $settings = App\Models\Settings::get_settings();
@endphp

@section('title')
    Bill Increase Warning Report
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Bill Increase Warning Report</h4>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <div class="mt-2" id="multiCollapseExample1">
                <div class="card">
                    <div class="card-body">
                        <form id="reportForm" action="{{ route('report.bill-increase-warning-report') }}" method="GET"
                            id="report_collection_summaryy">
                            <div class="row align-items-center justify-content-end">
                                <div class="col-xl-12">
                                    <div class="row align-items-end">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="customer" class="form-label">Customer</label>
                                                <select name="customer" id="customer" class="form-control select2">
                                                    <option value="">All Customer</option>
                                                    @foreach ($customers as $customer)
                                                        <option value="{{ $customer->id }}"
                                                            {{ request('customer') == $customer->id ? 'selected' : '' }}>
                                                            {{ $customer->customer_name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="start_date">Upto Date*</label>
                                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                                    <input type="text"
                                                        class="form-control has-feedback-left custom-datepicker"
                                                        name="start_date" id="start_date"
                                                        value="{{ request('start_date') }}" placeholder="dd/mm/yyyy"
                                                        autocomplete="off" required>
                                                    <span class="fa fa-calendar-o form-control-feedback left"
                                                        aria-hidden="true"></span>
                                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <button class="btn btn-primary btn-block process-btn" type="submit"
                                                    name="search_button">
                                                    Filter
                                                </button>
                                            </div>
                                        </div>
                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <a href="{{ route('report.bill-increase-warning-report') }}"
                                                    class="btn btn-danger btn-block">
                                                    Clear
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <br>

    @if(request()->has('start_date'))

    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h6 class="text-primary mb-0"></h6>
        </div>
        <div class="col-md-6 text-right">

            <a href="javascript:void(0);" onclick="$('#exportForm').submit();" class="btn btn-warning text-dark">
                <img class="d-inline mr-2 mb-1" height="20px" src="{{ asset('images/pdf.png') }}">PDF
            </a>

            <a href="javascript:void(0);" onclick="$('#exportFormExcel').submit();" class="btn btn-warning text-dark">
                <img class="d-inline mr-2 mb-1" height="20px" src="{{ asset('images/excel.svg') }}">Excel
            </a>

            <form id="exportForm" action="{{ route('bill-increase-warning-report.export','pdf') }}" method="POST">
                @csrf
                <input type="hidden" name="rpt_customer" value="{{ request('customer') }}">
                <input type="hidden" name="rpt_start_date" value="{{ request('start_date') }}">
            </form>

            <form id="exportFormExcel" action="{{ route('bill-increase-warning-report.export','excel') }}" method="POST" style="display:none;">
                @csrf
                <input type="hidden" name="rpt_customer" value="{{ request('customer') }}">
                <input type="hidden" name="rpt_start_date" value="{{ request('start_date') }}">
            </form>

        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div id="printableArea" class="x_content" style="padding:0;overflow:auto">
                    <div class="row">
                        <div class="col-12 mb-2 heading-box" style="text-align: center; color:#000">
                            <p style="font-size: 20px !important;font-style:italic">SQUARE INFORMATIX LIMITED</p>
                            <p style="font-size: 17px !important;">ACCOUNTS DEPARTMENT</p>
                            <p style="font-size: 17px !important;">Bill Increase Warning Report</p>
                            <p style="font-size: 14px !important;">Upto: {{ request('start_date') }}</p>
                        </div>
                        <div style="color: #000;width: 100%;">Printing Date: {{date('d/m/Y')}}</div>
                    </div>

                    <div class="row">
                        <table class="table table-bordered invoice-table mt-1" style="width:100%;">
                            <thead>
                                <tr>
                                    <th>Sl.</th>
                                    <th>Ref. No.</th>
                                    <th>Ref. Date</th>
                                    <th>Customer</th>
                                    <th>Particulars</th>
                                    <th>Start<br>Date</th>
                                    <th>End<br>Date</th>
                                    <th>Increase<br>Period (Month)</th>
                                    <th>Increase<br>Date</th>
                                    <th>Increase<br>%</th>
                                    {{-- <th>Old Bill No.</th> --}}
                                    <th>Bill No.</th>
                                    <th>Bill<br>Group</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($bills as $bill)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td style="width:170px;">
                                            @php
                                                $string = $bill->ref_no;
                                                $formattedString = preg_replace('/([\/_])/', '$1 ', $string);
                                            @endphp
                                            {{ $formattedString }}
                                        </td>
                                        <td style="width:70px;">{{ $bill->ref_date }}</td>
                                        <td style="width:150px;">{{ $bill->customer_name }}</td>
                                        <td style="width:210px;">
                                            @php
                                                $string = $bill->particulars;
                                                $formattedString = preg_replace('/([\/_])/', '$1 ', $string);
                                            @endphp
                                            {{ $formattedString }}
                                        </td>

                                        <td style="width:70px;">{{ $bill->start_date }}</td>
                                        <td style="width:70px;">{{ $bill->end_date }}</td>
                                        <td class="text-center">{{ $bill->increase_period }}</td>
                                        <td style="width:70px;"><b>{{ $bill->increase_start_date }}</b></td>
                                        <td class="text-right">
                                            <b>
                                                @php
                                                    $percent = trim($bill->yearly_increase_percent);
                                                @endphp
                                                {{ is_numeric($percent) ? number_format((float)$percent, 2) : '0.00' }} %
                                            </b>
                                        </td>
                                        {{-- <td>{{ $bill->OLD_BILL_NO }}</td> --}}
                                        <td>{{ $bill->BILL_NO }}</td>
                                        <td class="text-center">{{ $bill->bill_group }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif


    <style>
        .x_content{
            font-family: arial !important;
            color:#000 !important;
            font-size:13px;
        }
        .invoice-table,
        .invoice-table th,
        .invoice-table td {
            border: 0.5px solid #000 !important;
            border-collapse: collapse !important;
            font-size:12px;
            font-family: arial !important;
        }
        .invoice-table th {
            text-align: left;
            background-color: white;
            color: black;
            font-weight: bold;
            padding:2px !important;
        }
        .invoice-table td {
            padding:2px 4px !important;
        }
        h1, h2, h3, h4, h5, h6, p, .black, div{
            /* color: #000 !important; */
        }
        p{
            margin-bottom: 1px;
            font-size: 13px;
        }
    </style>
@endsection

@section('script')
    <script>
        $('.process-btn').click(function () {
            const form = $('#reportForm')[0];
            if (!form.checkValidity()) {
                form.reportValidity();
                return;
            }
            $('.ajaxLoaderFormLoad').show();
            form.submit();
        });
    </script>
@endsection
