@extends('layouts.app')

@php
    $settings = App\Models\Settings::get_settings();
@endphp

@section('title')
    Customer Bill Summary
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Customer Bill Summary</h4>
        </div>
        <div class="col-md-6 text-right">
            <button class="btn btn-warning" onclick="saveAsPDF()"><img class="d-inline mr-2 mb-1" height="20px"
                    src="{{ asset('images/pdf.png') }}">PDF</button>
            <a href="{{ route('customer-bill-summary.export') }}" class="btn btn-warning text-dark"><img class="d-inline mr-2 mb-1"
                    height="18px" src="{{ asset('images/excel.svg') }}">Excel</a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div id="printableArea" class="x_content" style="padding:0">
                    <div class="row">
                        <div class="col-12 mb-2">
                            <div class="row print-header mb-3 d-none">
                                <div class="col-6 px-0">
                                    <img height="60PX"
                                        src="{{ !empty($settings['company_logo_dark']) ? asset('storage/logo/' . $settings['company_logo_dark']) : asset('images/logo_placeholder.png') }}">
                                </div>
                                <div class="col-6 px-0 text-right">
                                    <p class="text-primary mt-2 mb-0"><b>{{ $settings['company_name'] }}</b></p>
                                    <p class="mb-0">
                                        {{ $settings['company_address'] ? $settings['company_address'] . ',' : '' }}</p>
                                    <p class="mb-0">{{ $settings['company_city'] . '-' . $settings['company_zip'] }}</p>
                                </div>
                            </div>
                            <h3 class="text-primary text-center" style="font-size: 22px;">Customer Bill Summary</h3>
                        </div>
                    </div>
                    <div class="row">
                        <table class="table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Sl No</th>
                                    <th>Customer ID</th>
                                    <th>Customer Name</th>
                                    <th>Total Bill</th>
                                    <th>Total Invoice</th>
                                    <th>Invoice Amount</th>
                                    <th>Invoice Amount (Paid)</th>
                                    <th>Invoice Amount (Due)</th>
                                </tr>
                            </thead>

                            <tbody>
                                @php
                                    $totalPaidAmount = 0;
                                    $totalDueAmount = 0;
                                @endphp
                                @foreach ($reportData as $row)
                                    @php
                                        $totalPaidAmount += $row['paid_amount'];
                                        $totalDueAmount += $row['due_amount'];
                                    @endphp
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ str_pad($row['customer_id'], 5, '0', STR_PAD_LEFT) }}</td>
                                        <td>{{ $row['customer_name'] }}</td>
                                        <td>{{ $row['total_bill'] }}</td>
                                        <td>{{ $row['total_invoice'] }}</td>
                                        <td style="text-align: right">{{ \App\Models\Settings::priceFormat($row['invoice_amount']) }}</td>
                                        <td style="text-align: right">{{ \App\Models\Settings::priceFormat($row['paid_amount']) }}</td>
                                        <td style="text-align: right">{{ \App\Models\Settings::priceFormat($row['due_amount']) }}</td>
                                    </tr>
                                @endforeach
                                <tr>
                                    <td colspan="6" class="text-right pr-3"><b>Total:</b></td>
                                    <td style="text-align: right"><b>{{ \App\Models\Settings::priceFormat($totalPaidAmount) }}</b></td>
                                    <td style="text-align: right"><b>{{ \App\Models\Settings::priceFormat($totalDueAmount) }}</b></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        function saveAsPDF() {
            $('table').addClass('custom-print');
            $('.print-header').removeClass('d-none');

            var printableArea = $('#printableArea').html();

            var opt = {
                margin: 0.3,
                filename: "customer-bill-summary",
                image: {
                    type: 'jpeg',
                    quality: 0.8
                },
                html2canvas: {
                    scale: 3,
                    dpi: 150,
                    letterRendering: true
                },
                jsPDF: {
                    unit: 'in',
                    format: 'A4'
                }
            };
            html2pdf().set(opt).from(printableArea).save();

            setTimeout(() => {
                $('table').removeClass('custom-print');
                $('.print-header').addClass('d-none');
            }, 100);

        }
    </script>
@endsection
