@extends('layouts.app')

@php
    $settings = App\Models\Settings::get_settings();
@endphp

@section('title')
    Customer Wise Bill
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Customer Wise Bill</h4>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <div class="mt-2" id="multiCollapseExample1">
                <div class="card">
                    <div class="card-body">
                        <form id="reportForm" action="{{ route('report.customer-wise-bill') }}" method="GET">
                            <div class="row align-items-center justify-content-end">
                                <div class="col-md-12">
                                    <div class="row align-items-end ">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="start_date">Start Date*</label>
                                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                                    <input type="text"
                                                        class="form-control has-feedback-left custom-datepicker"
                                                        name="start_date" id="start_date"
                                                        value="{{ request('start_date') }}" placeholder="dd/mm/yyyy"
                                                        autocomplete="off" required>
                                                    <span class="fa fa-calendar-o form-control-feedback left"
                                                        aria-hidden="true"></span>
                                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="end_date">End Date*</label>
                                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                                    <input type="text"
                                                        class="form-control has-feedback-left custom-datepicker"
                                                        name="end_date" id="end_date" value="{{ request('end_date') }}"
                                                        placeholder="dd/mm/yyyy" autocomplete="off" required>
                                                    <span class="fa fa-calendar-o form-control-feedback left"
                                                        aria-hidden="true"></span>
                                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="customer" class="form-label">Customer</label>
                                                <select name="customer" id="customer" class="form-control select2">
                                                    <option value="">Select Customer</option>
                                                    @foreach ($customers as $customer)
                                                        <option value="{{ $customer->id }}"
                                                            {{ request('customer') == $customer->id ? 'selected' : '' }}>
                                                            {{ $customer->customer_name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <button class="btn btn-primary btn-block process-btn" type="submit"
                                                    name="search_buttonn">
                                                    Filter
                                                </button>
                                            </div>
                                        </div>

                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <a href="{{ route('report.customer-wise-bill') }}"
                                                    class="btn btn-danger btn-block">
                                                    Clear
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <br>

    @if(request()->has('start_date'))

    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h6 class="text-primary mb-0"></h6>
        </div>
        <div class="col-md-6 text-right">

            <a href="javascript:void(0);" onclick="$('#exportForm').submit();" class="btn btn-warning text-dark">
                <img class="d-inline mr-2 mb-1" height="20px" src="{{ asset('images/pdf.png') }}">PDF
            </a>

            <button class="btn btn-warning" onclick="saveAsExcel()"><img class="d-inline mr-2 mb-1" height="20px"
                    src="{{ asset('images/excel.svg') }}">Excel </button>

            <form id="exportForm" action="{{ route('customer-wise-bill.export','pdf') }}" method="POST">
                @csrf
                <input type="hidden" name="rpt_start_date" value="{{ request('start_date') }}">
                <input type="hidden" name="rpt_end_date" value="{{ request('end_date') }}">
                <input type="hidden" name="rpt_customer" value="{{ request('customer') }}">
            </form>

        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div id="printableArea" class="x_content" style="padding:0">
                    {{-- <div class="row">
                        <div class="col-12 mb-2">
                            <div class="row print-header mb-3 d-none">
                                <div class="col-6 px-0">
                                    <img height="60PX"
                                        src="{{ !empty($settings['company_logo_dark']) ? asset('storage/logo/' . $settings['company_logo_dark']) : asset('images/logo_placeholder.png') }}">
                                </div>
                                <div class="col-6 px-0 text-right">
                                    <p class="text-primary mt-2 mb-0"><b>{{ $settings['company_name'] }}</b></p>
                                    <p class="mb-0">
                                        {{ $settings['company_address'] ? $settings['company_address'] . ',' : '' }}</p>
                                    <p class="mb-0">{{ $settings['company_city'] . '-' . $settings['company_zip'] }}</p>
                                </div>
                            </div>
                            <h3 class="text-primary text-center" style="font-size: 22px;">Customer Wise Bill</h3>
                        </div>
                    </div> --}}

                    <div class="row">
                        <div class="col-12 mb-2 heading-box" style="text-align: center; color:#000">
                            <p style="font-size: 20px !important;font-style:italic">SQUARE INFORMATIX LIMITED</p>
                            <p style="font-size: 18px !important;">ACCOUNTS DEPARTMENT</p>
                            <p style="font-size: 18px !important;">CUSTOMER WISE BILL</p>
                            <p style="font-size: 16px !important;">{{$dateRange}}</p>
                        </div>
                        <div style="color: #000;width: 100%;font-size:13px">Printing Date: {{date('d/m/Y')}}</div>
                    </div>
                    <div class="row">
                        <table id="export-table" class="table table-bordered invoice-table mt-1" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Sl</th>
                                    <th>Customer</th>
                                    <th>Invoice No</th>
                                    <th>Invoice Date</th>
                                    <th>Bill Subject</th>
                                    <th>Net<br>Amount</th>
                                    <th>VAT<br>(%)</th>
                                    <th>VAT<br>Amount</th>
                                    <th>Total<br>Amount</th>
                                </tr>
                            </thead>

                            <tbody>
                                @foreach ($bills as $bill)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $bill->customer->customer_name ?? '' }}</td>
                                        <td>{{ $bill->invoice_no }}</td>
                                        <td>{{ $bill->invoice_date }}</td>
                                        <td>{{ $bill->bill_subject_desc }}</td>
                                        <td class="text-right">{{ priceFormat($bill->total_amount) }}</td>
                                        <td class="text-right">{{ priceFormat($bill->vat_percent) }}</td>
                                        <td class="text-right">{{ priceFormat($bill->vat_amount) }}</td>
                                        <td class="text-right">{{ priceFormat($bill->total_amount_vat) }}</td>
                                    </tr>
                                @endforeach
                                <tr>

                                    <td colspan="5" class="text-right pr-3"><b>Total:</b></td>
                                    <td class="text-right"><b>{{ priceFormat($grandNetTotal) }}</b></td>
                                    <td><b></b></td>
                                    <td class="text-right"><b>{{ priceFormat($grandVat) }}</b></td>
                                    <td class="text-right"><b>{{ priceFormat($grandTotalAmount) }}</b></td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endif


    <style>
        .x_content{
            font-family: arial !important;
            color:#000 !important;
            font-size:13px;
        }
        .invoice-table,
        .invoice-table th,
        .invoice-table td {
            border: 0.5px solid #000 !important;
            border-collapse: collapse !important;
            font-size:12px;
            font-family: arial !important;
        }
        .invoice-table th {
            background-color: white;
            color: black;
            font-weight: bold;
            padding:2px !important;
        }
        .invoice-table td {
            padding:2px 4px !important;
        }
        h1, h2, h3, h4, h5, h6, p, .black, div{
            /* color: #000 !important; */
        }
        p{
            margin-bottom: 1px;
            font-size: 13px;
        }
    </style>
@endsection

@section('script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.0/xlsx.full.min.js"></script>

    <script>
        function saveAsPDF() {
            $('table').addClass('custom-print');
            $('.print-header').removeClass('d-none');

            var printableArea = $('#printableArea').html();

            var opt = {
                margin: 0.3,
                filename: "Customer-wise-bill_{{date('Y-m-d')}}",
                image: {
                    type: 'jpeg',
                    quality: 0.8
                },
                html2canvas: {
                    scale: 3,
                    dpi: 150,
                    letterRendering: true
                },
                jsPDF: {
                    unit: 'in',
                    format: 'A4'
                }
            };
            html2pdf().set(opt).from(printableArea).save();

            setTimeout(() => {
                $('table').removeClass('custom-print');
                $('.print-header').addClass('d-none');
            }, 100);
        }
    </script>

    <script>
        function saveAsExcel() {
            var table = document.querySelector('table');

            var workbook = XLSX.utils.book_new();
            var worksheet = XLSX.utils.aoa_to_sheet([
                ["SQUARE INFORMATIX LIMITED"]
            ]);

            worksheet["A2"] = { v: "ACCOUNTS DEPARTMENT" };
            worksheet["A3"] = { v: "CUSTOMER WISE BILL" };
            worksheet["A4"] = { v: "Printing Date: {{ date('d/m/Y') }}" };

            var tableCols = table.querySelectorAll('th').length;
            var merge = [{
                s: {
                    r: 0,
                    c: 0
                },
                e: {
                    r: 0,
                    c: tableCols - 1
                }
            }];
            if (!worksheet['!merges']) worksheet['!merges'] = [];
            worksheet['!merges'] = worksheet['!merges'].concat(merge);

            var headingCell = worksheet['A1'];
            headingCell.s = {
                fill: {
                    fgColor: {
                        rgb: "112f6f"
                    }
                },
                font: {
                    bold: true,
                    color: {
                        rgb: "FFFFFF"
                    }
                },
                alignment: {
                    horizontal: "center",
                    vertical: "center"
                }
            };

            XLSX.utils.sheet_add_dom(worksheet, table, {
                origin: 'A5',
                raw: true
            });

            var columnWidths = [];
            table.querySelectorAll('tr').forEach(function(row) {
                row.querySelectorAll('td, th').forEach(function(cell, columnIndex) {
                    var cellContent = cell.textContent || '';
                    var cellWidth = cellContent.length + 2;
                    if (!columnWidths[columnIndex] || cellWidth > columnWidths[columnIndex]) {
                        columnWidths[columnIndex] = cellWidth;
                    }
                });
            });
            worksheet['!cols'] = columnWidths.map(function(width) {
                return {
                    width: width
                };
            });

            XLSX.utils.book_append_sheet(workbook, worksheet, "Sheet1");

            var excelFile = XLSX.write(workbook, {
                bookType: 'xlsx',
                type: 'binary'
            });

            function s2ab(s) {
                var buf = new ArrayBuffer(s.length);
                var view = new Uint8Array(buf);
                for (var i = 0; i < s.length; i++) view[i] = s.charCodeAt(i) & 0xFF;
                return buf;
            }
            var blob = new Blob([s2ab(excelFile)], {
                type: "application/octet-stream"
            });
            var link = document.createElement('a');
            link.href = URL.createObjectURL(blob);
            link.download = "Customer_wise_bill_{{date('Y-m-d')}}.xlsx";
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }
    </script>
    <script>
        $('.process-btn').click(function () {
            const form = $('#reportForm')[0];
            if (!form.checkValidity()) {
                form.reportValidity();
                return;
            }
            $('.ajaxLoaderFormLoad').show();
            form.submit();
        });
    </script>
@endsection
