@extends('layouts.app')

@php
    $settings = App\Models\Settings::get_settings();
@endphp

@section('title')
    Department Wise Monthly Net Sales
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Department Wise Monthly Net Sales</h4>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <div class="mt-2" id="multiCollapseExample1">
                <div class="card">
                    <div class="card-body">
                        <form id="reportForm" action="{{ route('report.dept-wise-monthly-sales') }}" method="GET">
                            <div class="row align-items-center justify-content-end">
                                <div class="col-md-12">
                                    <div class="row align-items-end">

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="start_date">Start Date*</label>
                                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                                    <input type="text"
                                                        class="form-control has-feedback-left custom-datepicker"
                                                        name="start_date" id="start_date"
                                                        value="{{ request('start_date') }}" placeholder="dd/mm/yyyy"
                                                        autocomplete="off" required>
                                                    <span class="fa fa-calendar-o form-control-feedback left"
                                                        aria-hidden="true"></span>
                                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="end_date">End Date*</label>
                                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                                    <input type="text"
                                                        class="form-control has-feedback-left custom-datepicker"
                                                        name="end_date" id="end_date"
                                                        value="{{ request('end_date') }}" placeholder="dd/mm/yyyy"
                                                        autocomplete="off" required>
                                                    <span class="fa fa-calendar-o form-control-feedback left"
                                                        aria-hidden="true"></span>
                                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <button class="btn btn-primary btn-block process-btn" type="submit"
                                                    name="search_buttonn">
                                                    Filter
                                                </button>
                                            </div>
                                        </div>

                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <a href="{{ route('report.dept-wise-monthly-sales') }}"
                                                    class="btn btn-danger btn-block">
                                                    Clear
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <br>



    @if(isset($reportData) && count($reportData) > 0)

    <div class="row">

        <div class="row d-flex align-items-center mb-3">
            <div class="col-md-6">
                <h6 class="text-primary mb-0"></h6>
            </div>
            <div class="col-md-6 text-right">
                <button class="btn btn-warning" onclick="saveAsPDF()"><img class="d-inline mr-2 mb-1" height="20px"
                        src="{{ asset('images/pdf.png') }}">PDF</button>

                <button class="btn btn-warning" onclick="saveAsExcel()"><img class="d-inline mr-2 mb-1" height="20px"
                        src="{{ asset('images/excel.svg') }}">Excel </button>
            </div>
        </div>

        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div id="printableArea" class="x_content" style="padding:0;overflow:auto">
                    <div style="color: #000;text-align: right;position: absolute;width: 100%;">Printing Date: {{date('d/m/Y')}}</div>
                    <div class="row">
                        <div class="col-12 mb-2 heading-box" style="text-align: center; color:#000">
                            <h3 style="font-size: 20px;font-style:italic">SQUARE INFORMATIX LIMITED</h3>
                            <h3 style="font-size: 18px;">ACCOUNTS DEPARTMENT</h3>
                            <h3 style="font-size: 18px;">DEPARTMENT WISE MONTHLY NET SALES</h3>
                            <h3 style="font-size: 16px;">From: {{ request('start_date') }} To: {{ request('end_date') }}</h3>
                        </div>
                    </div>
                    <div class="row">
                        <table class="table table-bordered tbl-result">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th style="text-align:left">Department</th>
                                    @foreach ($monthName as $m)
                                        <th>{{$m}}</th>
                                    @endforeach
                                    <th>Total</th>
                                </tr>
                            </thead>
                            <tbody>
                            @isset($reportData)
                                @foreach($reportData as $row)
                                    <tr>
                                        <td style="text-align:center">{{$loop->iteration}}</td>
                                        <td style="text-align: left">
                                            {{$row->billDivName}}
                                        </td>

                                        @php
                                            $total = 0;
                                        @endphp

                                        @foreach ($months as $m)
                                            <td>{{ priceFormat($row->{$m}) }}</td>

                                            @php
                                                $total = $total + $row->{$m};
                                            @endphp
                                        @endforeach

                                        <td style="font-weight: bold">{{ priceFormat($total) }}</td>
                                    </tr>
                                @endforeach
                            @endisset
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <style>
        .tbl-result th, .tbl-result td{
            font-size: 12px;
            padding: 3px 2px !important;
            border-color: #000 !important;
        }
        .tbl-result th{
            color: #000;
            background-color: #fff;
            text-align: center;
        }
        .tbl-result td{
            text-align: right;
        }
        .heading-box h3{
            margin: 4px;
        }
    </style>

@endif



@endsection

@section('script')
    <script>
        function saveAsPDF() {
            $('table').addClass('custom-print');
            $('.print-header').removeClass('d-none');

            var printableArea = $('#printableArea').html();

            var opt = {
                margin: 0.1,
                filename: "Department-wise-monthly-net-sales",
                image: {
                    type: 'jpeg',
                    quality: 0.8
                },
                html2canvas: {
                    scale: 3,
                    dpi: 150,
                    letterRendering: true
                },
                jsPDF: {
                    unit: 'in',
                    format: 'legal',
                    orientation: 'landscape'
                }
            };
            html2pdf().set(opt).from(printableArea).save();

            setTimeout(() => {
                $('table').removeClass('custom-print');
                $('.print-header').addClass('d-none');
            }, 100);
        }
    </script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.0/xlsx.full.min.js"></script>

    <script>
        function saveAsExcel() {
            var table = document.querySelector('table');

            var workbook = XLSX.utils.book_new();
            var worksheet = XLSX.utils.aoa_to_sheet([
                ["SQUARE INFORMATIX LIMITED"]
            ]);

            worksheet["A2"] = { v: "ACCOUNTS DEPARTMENT" };
            worksheet["A3"] = { v: "DEPARTMENT WISE MONTHLY NET SALES" };
            worksheet["A4"] = { v: "From: {{ request('start_date') }} To: {{ request('end_date') }}" };
            worksheet["A5"] = { v: "Printing Date: {{ date('d/m/Y') }}" };

            var tableCols = table.querySelectorAll('th').length;
            var merge = [{
                s: {
                    r: 0,
                    c: 0
                },
                e: {
                    r: 0,
                    c: tableCols - 1
                }
            }];
            if (!worksheet['!merges']) worksheet['!merges'] = [];
            worksheet['!merges'] = worksheet['!merges'].concat(merge);

            var headingCell = worksheet['A1'];
            headingCell.s = {
                fill: {
                    fgColor: {
                        rgb: "112f6f"
                    }
                },
                font: {
                    bold: true,
                    color: {
                        rgb: "FFFFFF"
                    }
                },
                alignment: {
                    horizontal: "center",
                    vertical: "center"
                }
            };

            XLSX.utils.sheet_add_dom(worksheet, table, {
                origin: 'A6',
                raw: true
            });

            var columnWidths = [];
            table.querySelectorAll('tr').forEach(function(row) {
                row.querySelectorAll('td, th').forEach(function(cell, columnIndex) {
                    var cellContent = cell.textContent || '';
                    var cellWidth = cellContent.length + 2;
                    if (!columnWidths[columnIndex] || cellWidth > columnWidths[columnIndex]) {
                        columnWidths[columnIndex] = cellWidth;
                    }
                });
            });
            worksheet['!cols'] = columnWidths.map(function(width) {
                return {
                    width: width
                };
            });

            XLSX.utils.book_append_sheet(workbook, worksheet, "Sheet1");

            var excelFile = XLSX.write(workbook, {
                bookType: 'xlsx',
                type: 'binary'
            });

            function s2ab(s) {
                var buf = new ArrayBuffer(s.length);
                var view = new Uint8Array(buf);
                for (var i = 0; i < s.length; i++) view[i] = s.charCodeAt(i) & 0xFF;
                return buf;
            }
            var blob = new Blob([s2ab(excelFile)], {
                type: "application/octet-stream"
            });
            var link = document.createElement('a');
            link.href = URL.createObjectURL(blob);
            link.download = "Department-wise-monthly-net-sales.xlsx";
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }
    </script>

    <script>
        $(document).ready(function () {
            $(".custom-datepicker2").each(function () {
                $(this).datepicker({
                    format: "mm/yyyy",
                    startView: "months",
                    minViewMode: "months",
                    autoclose: true,
                    templates: {
                        leftArrow: '<i class="fa fa-chevron-left"></i>',
                        rightArrow: '<i class="fa fa-chevron-right"></i>',
                    },
                });
            });
        });
    </script>


    <script>
        $('#customer_id').select2({
            placeholder: "--Select Customer--",
            allowClear: true
        });
    </script>
    <script>
        $('.process-btn').click(function () {
            const form = $('#reportForm')[0];
            if (!form.checkValidity()) {
                form.reportValidity();
                return;
            }
            $('.ajaxLoaderFormLoad').show();
            form.submit();
        });
    </script>

@endsection

