<table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
    <thead>
        <tr>
        <th colspan="10" align="center" bgcolor="#112f6f" style="font-weight: bold; color: #ffffff;">Customer Wise Bill </th>
        </tr>
        <tr>
            <th>Sl No</th>
            <th>Customer</th>
            <th>Invoice No.</th>
            <th>Bill Date</th>
            <th>Department</th>
            <th>Subject</th>
            <th>Total Bill Amount (৳)</th>
            <th>VAT Amount (%)</th>
            <th>Net Bill Amount (৳)</th>
        </tr>
    </thead>

    <tbody>
        @php
            $totalBillAmount = 0;
            $totalVatAmount = 0;
            $totalNetBillAmount = 0;
        @endphp
        @foreach ($bills as $billprocess)
            @php
                $netBillAmount = $billprocess->total_amount * $billprocess->vat_percent / 100;
                $netBillAmountall = $billprocess->total_amount - $netBillAmount;

                $totalBillAmount += $billprocess->total_amount;
                $totalVatAmount += $billprocess->vat_percent;
                $totalNetBillAmount += $netBillAmountall;
            @endphp
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $billprocess->customer->customer_name }}</td>
                <td>{{ $billprocess->invoice_no }}</td>
                <td>{{ $billprocess->invoice_date }}</td>
                <td>{{ $billprocess->department->department_name }}</td>
                <td>{{ $billprocess->billSubject->bill_subject ?? '' }}</td>
                <td>{{ \App\Models\Settings::priceFormat ( $billprocess->total_amount) }}</td>
                <td>{{ \App\Models\Settings::formatVatPercentage( $billprocess->vat_percent) }}</td>
                <td>{{ \App\Models\Settings::priceFormat( $netBillAmountall) }}</td>
            </tr>
        @endforeach
        <tr>
            <td colspan="6" class="text-right pr-3"><b>Total:</b></td>
            <td><b>{{ \App\Models\Settings::priceFormat( $totalBillAmount) }}</b></td>
            <td><b></b></td>
            <td><b>{{ \App\Models\Settings::priceFormat( $totalNetBillAmount) }}</b></td>
        </tr>
    </tbody>

</table>