<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bill Increase Warning Report</title>
</head>
<body>
    <div class="row mt-2">
        <div class="col-md-12">
            <div class="row">
                <div class="col-12 mb-2 heading-box" style="text-align: center; color:#000">
                    <p style="font-size: 20px !important;font-style:italic">SQUARE INFORMATIX LIMITED</p>
                    <p style="font-size: 17px !important;">ACCOUNTS DEPARTMENT</p>
                    <p style="font-size: 17px !important;">
                        Bill Increase Warning Report
                        @if(!empty($customer))
                            – {{ $bills[0]->customer_name ?? '' }}
                        @endif
                    </p>
                    <p style="font-size: 14px !important;">Upto: {{$start_date}}</p>
                </div>
            </div>

            <div class="date-stamp">Printing Date: {{ date('d/m/Y') }}</div>
            <table class="table table-bordered invoice-table mt-10" style="width:100%">
                <thead>
                    <tr>
                        <th>Sl.</th>
                        <th>Ref. No.</th>
                        <th>Ref. Date</th>
                        <th>Customer</th>
                        <th>Particulars</th>
                        <th>Start<br>Date</th>
                        <th>End<br>Date</th>
                        <th>Increase<br>Period (Month)</th>
                        <th>Increase<br>Date</th>
                        <th style="text-align: right"><nobr>Increase %</nobr></th>
                        {{-- <th>Old Bill No.</th> --}}
                        <th>Bill No.</th>
                        <th>Bill Group</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($bills as $bill)
                        <tr>
                            <td style="width:20px;" class="text-right">{{ $loop->iteration }}</td>
                            <td style="width:150px;">
                                @php
                                    $formattedString = preg_replace('/([\/_])/', '$1 ', $bill->ref_no);
                                @endphp
                                {{ $formattedString }}
                            </td>
                            <td class="text-center">{{ $bill->ref_date }}</td>
                            <td style="width:160px;">{{ $bill->customer_name }}</td>
                            <td style="">
                                @php
                                    $formattedString = preg_replace('/([\/_])/', '$1 ', $bill->particulars);
                                @endphp
                                {{ $formattedString }}
                            </td>
                            <td class="text-center">{{ $bill->start_date }}</td>
                            <td class="text-center">{{ $bill->end_date }}</td>
                            <td class="text-center">{{ $bill->increase_period }}</td>
                            <td class="text-center">{{ $bill->increase_start_date }}</td>

                            <td class="text-right">
                                <b>
                                    @php
                                        $percent = trim($bill->yearly_increase_percent);
                                    @endphp
                                    {{ is_numeric($percent) ? number_format((float)$percent, 2) : '0.00' }} %
                                </b>
                            </td>
                            {{-- <td class="text-center">{{ $bill->OLD_BILL_NO }}</td> --}}
                            <td class="text-center">{{ $bill->BILL_NO }}</td>
                            <td class="text-center">{{ $bill->bill_group }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <style>
        .x_content{
            font-family: arial !important;
            color:#000 !important;
            font-size:13px;
        }
        .table {
            width: 100%;
            margin-bottom: 1rem;
            color: #212529;
        }
        .invoice-table, .invoice-table th, .invoice-table td {
            border: 0.5px solid #000 !important;
            border-collapse: collapse !important;
            /* font-size: 12px !important; */
            font-size: 11px !important;
        }
        .invoice-table th {
            background-color: white;
            color: black;
            font-weight: bold;
            padding:3px 6px !important;
            text-align: left;
        }
        .invoice-table td {
            padding:3px 6px !important;
        }
        .text-right{
            text-align: right;
        }
        .text-center{
            text-align: center;
        }
        .date-stamp{
            font-size: 14px;
            margin-top: 5px;
            margin-bottom: 8px;
        }
        .heading-box p {
            margin: 0;
        }
    </style>
    <style>
        /* body {
            font-family: DejaVu Sans, Arial, sans-serif !important;
        }
        table, td, th, p {
            font-family: DejaVu Sans, Arial, sans-serif !important;
        } */
        body {
            font-family: Arial, sans-serif !important;
        }
        table, td, th, p {
            font-family: Arial, sans-serif !important;
        }
    </style>
</body>
</html>
