@extends('layouts.app')

@php
    $settings = App\Models\Settings::get_settings();
@endphp

@section('title')
Posted Unposted Bills
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Posted Unposted Bills</h4>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <div class="mt-2" id="multiCollapseExample1">
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('post-unpost-bill') }}" method="GET" autocomplete="off">
                            <div class="row align-items-center justify-content-end">
                                <div class="col-md-12">
                                    <div class="row align-items-end">
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label for="start_date">Start Month</label>
                                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                                    <input type="text" name="start_date" class="form-control monthpicker"
                                                        id="start_date" value="{{request('start_date')}}" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label for="end_date">End Month</label>
                                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                                    <input type="text" name="end_date" class="form-control monthpicker"
                                                        id="end_date" value="{{request('end_date')}}" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="customer" class="form-label">Customer</label>
                                                <select name="customer" id="customer" class="form-control select2">
                                                    <option value="">Select customer</option>
                                                    @foreach ($customers as $customer)
                                                        <option value="{{ $customer->id }}"
                                                            {{ request('customer') == $customer->id ? 'selected' : '' }}>
                                                            {{ $customer->customer_name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="type" class="form-label">Type</label>
                                                <select name="type" id="type" class="form-control select2" required>
                                                    <option value="unposted"
                                                        {{ request('type') == 'unposted' ? 'selected' : '' }}>Unposted</option>
                                                    <option value="posted"
                                                        {{ request('type') == 'posted' ? 'selected' : '' }}>Posted</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <button class="btn btn-primary btn-block" type="submit"
                                                    name="search_buttonn">
                                                    Filter
                                                </button>
                                            </div>
                                        </div>

                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <a href="{{ route('post-unpost-bill') }}"
                                                    class="btn btn-danger btn-block">
                                                    Clear
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <br>

    @if(request('type')=='posted')
        <h3 class="text-primary text-center" style="font-size: 22px;">Posted Bill</h3>
    @elseif(request('type')=='unposted')
        <h3 class="text-primary text-center" style="font-size: 22px;">Unposted Bill</h3>
    @else
    @endif

    @if(request('start_date')!='')

    <div class="row">
        <table id="export-table" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th>Sl</th>
                    <th>Customer</th>
                    <th>BIll No.</th>
                    <th>Bill Date</th>
                    <th>Subject</th>
                    <th>Currency</th>
                    <th>VAT Amount</th>
                    <th>Total Amount</th>
                    @if(request('type') == 'unposted')
                    <th>Action</th>
                    @endif
                </tr>
            </thead>

            <tbody>
                @foreach ($bills as $row)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $row->customer ? $row->customer->customer_name : '-' }}</td>
                        <td>{{ str_pad($row->id, 5, '0', STR_PAD_LEFT) }}</td>
                        <td>{{ date('d/m/Y', strtotime($row->created_at)) }}</td>
                        <td>{{ $row->billSubject->bill_subject ?? '' }}</td>
                        <td>{{ $row->currency }}</td>
                        <td class="text-right">{{ \App\Models\Settings::priceFormat($row->vat_amount) }}</td>
                        <td class="text-right">{{ \App\Models\Settings::priceFormat($row->total_amount_vat) }}</td>
                        @if(request('type') == 'unposted')
                        <td>
                            @can('Edit Bill')
                                <a href="{{ route('bills.edit', $row->id) }}" class="btn btn-warning btn-sm text-dark">Edit</a>
                            @endcan

                            {{-- <a data-size="xl" class="btn btn-success btn-sm text-white cursor-pointer"
                                data-url="{{ route('bill.process.view', $row->id) }}" data-ajax-popup="true"
                                data-title="Bill Process" data-bs-toggle="tooltip" title="Process"
                                data-original-title="View">Bill Process</a> --}}

                            <a href="{{ route('unposting.invoice', ['id' => $row->id]) }}" target="_blank"
                                class="btn btn-info btn-sm">Pre Invoice</a>
                        </td>
                        @endif
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    @endif


@endsection

@section('script')
    <script>
        $(document).ready(function() {
            $('.monthpicker').datepicker({
                format: "mm-yyyy",
                startView: "months",
                minViewMode: "months",
                autoclose: true
            });
        });
    </script>
@endsection
