@extends('layouts.app')

@php
    $settings = App\Models\Settings::get_settings();
@endphp

@section('title')
    Customer Wise Bill
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Customer Wise Bill</h4>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <div class="mt-2" id="multiCollapseExample1">
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('report.customer-wise-bill') }}" method="GET">
                            <div class="row align-items-center justify-content-end">
                                <div class="col-md-12">
                                    <div class="row align-items-end ">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="start_date">Start Date*</label>
                                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                                    <input type="text"
                                                        class="form-control has-feedback-left custom-datepicker"
                                                        name="start_date" id="start_date"
                                                        value="{{ request('start_date') }}" placeholder="dd/mm/yyyy"
                                                        autocomplete="off" required>
                                                    <span class="fa fa-calendar-o form-control-feedback left"
                                                        aria-hidden="true"></span>
                                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="end_date">End Date*</label>
                                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                                    <input type="text"
                                                        class="form-control has-feedback-left custom-datepicker"
                                                        name="end_date" id="end_date" value="{{ request('end_date') }}"
                                                        placeholder="dd/mm/yyyy" autocomplete="off" required>
                                                    <span class="fa fa-calendar-o form-control-feedback left"
                                                        aria-hidden="true"></span>
                                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="customer" class="form-label">Customer</label>
                                                <select name="customer" id="customer" class="form-control select2">
                                                    <option value="">Select customer</option>
                                                    @foreach ($customers as $customer)
                                                        <option value="{{ $customer->id }}"
                                                            {{ request('customer') == $customer->id ? 'selected' : '' }}>
                                                            {{ $customer->customer_name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <button class="btn btn-primary btn-block" type="submit"
                                                    name="search_buttonn">
                                                    Filter
                                                </button>
                                            </div>
                                        </div>

                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <a href="{{ route('report.customer-wise-bill') }}"
                                                    class="btn btn-danger btn-block">
                                                    Clear
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <br>

    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h6 class="text-primary mb-0"></h6>
        </div>
        <div class="col-md-6 text-right">
            <button class="btn btn-warning" onclick="saveAsPDF()"><img class="d-inline mr-2 mb-1" height="20px"
                    src="{{ asset('images/pdf.png') }}">PDF</button>

            {{-- <button class="btn btn-warning" onclick="saveAsExcel()"><img class="d-inline mr-2 mb-1" height="20px"
                    src="{{ asset('images/excel.svg') }}">Excel </button> --}}
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div id="printableArea" class="x_content" style="padding:0">
                    <div class="row">
                        <div class="col-12 mb-2">
                            <div class="row print-header mb-3 d-none">
                                <div class="col-6 px-0">
                                    <img height="60PX"
                                        src="{{ !empty($settings['company_logo_dark']) ? asset('storage/logo/' . $settings['company_logo_dark']) : asset('images/logo_placeholder.png') }}">
                                </div>
                                <div class="col-6 px-0 text-right">
                                    <p class="text-primary mt-2 mb-0"><b>{{ $settings['company_name'] }}</b></p>
                                    <p class="mb-0">
                                        {{ $settings['company_address'] ? $settings['company_address'] . ',' : '' }}</p>
                                    <p class="mb-0">{{ $settings['company_city'] . '-' . $settings['company_zip'] }}</p>
                                </div>
                            </div>
                            <h3 class="text-primary text-center" style="font-size: 22px;">Customer Wise Bill</h3>
                        </div>
                    </div>
                    <div class="row">
                        <table id="export-table" class="table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Sl</th>
                                    <th>Customer</th>
                                    <th>Invoice No</th>
                                    <th>Invoice Date</th>
                                    <th>Subject</th>
                                    <th>Bill Amount</th>
                                    <th>VAT(%)</th>
                                    <th>Total Bill Amount</th>
                                </tr>
                            </thead>

                            <tbody>
                                @php
                                    $totalBillAmount = 0;
                                    $totalVatAmount = 0;
                                    $totalNetBillAmount = 0;
                                @endphp
                                @foreach ($bills as $billprocess)
                                    @php
                                        $netBillAmount = ($billprocess->total_amount * $billprocess->vat_percent) / 100;
                                        $netBillAmountall = $billprocess->total_amount + $netBillAmount;

                                        $totalBillAmount += $billprocess->total_amount;
                                        $totalVatAmount += $billprocess->vat_percent;
                                        $totalNetBillAmount += $netBillAmountall;
                                    @endphp
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $billprocess->customer ? $billprocess->customer->customer_name : '-' }}</td>
                                        <td>{{ $billprocess->invoice_no }}</td>
                                        <td>{{ $billprocess->invoice_date }}</td>
                                        </td>
                                        <td>{{ $billprocess->billSubject->bill_subject ?? '' }}</td>
                                        <td>{{ \App\Models\Settings::priceFormat($billprocess->total_amount) }}</td>
                                        <td>{{ \App\Models\Settings::formatVatPercentage($billprocess->vat_percent) }}
                                        </td>
                                        <td>{{ \App\Models\Settings::priceFormat($netBillAmountall) }}</td>
                                    </tr>
                                @endforeach
                                <tr>

                                    <td colspan="5" class="text-right pr-3"><b>Total:</b></td>
                                    <td><b>{{ \App\Models\Settings::priceFormat($totalBillAmount) }}</b></td>
                                    <td><b></b></td>
                                    <td><b>{{ \App\Models\Settings::priceFormat($totalNetBillAmount) }}</b></td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.0/xlsx.full.min.js"></script>

    <script>
        function saveAsPDF() {
            $('table').addClass('custom-print');
            $('.print-header').removeClass('d-none');

            var printableArea = $('#printableArea').html();

            var opt = {
                margin: 0.3,
                filename: "customer-Wise-bill",
                image: {
                    type: 'jpeg',
                    quality: 0.8
                },
                html2canvas: {
                    scale: 3,
                    dpi: 150,
                    letterRendering: true
                },
                jsPDF: {
                    unit: 'in',
                    format: 'A4'
                }
            };
            html2pdf().set(opt).from(printableArea).save();

            setTimeout(() => {
                $('table').removeClass('custom-print');
                $('.print-header').addClass('d-none');
            }, 100);
        }
    </script>

    <script>
        function saveAsExcel() {
            var table = document.querySelector('#export-table');
            var wb = XLSX.utils.book_new();
            var ws = XLSX.utils.table_to_sheet(table);

            var heading = [
                ["Customer Wise Bill"]
            ];
            XLSX.utils.sheet_add_aoa(ws, heading, {
                origin: 'A1'
            });

            var merge = [{
                s: {
                    r: 0,
                    c: 0
                },
                e: {
                    r: 0,
                    c: 8
                }
            }];
            if (!ws['!merges']) ws['!merges'] = [];
            ws['!merges'] = ws['!merges'].concat(merge);

            var colWidths = [];
            var range = XLSX.utils.decode_range(ws['!ref']);
            for (let C = range.s.c; C <= range.e.c; ++C) {
                let maxWidth = 10;
                for (let R = range.s.r; R <= range.e.r; ++R) {
                    var cell = ws[XLSX.utils.encode_cell({
                        r: R,
                        c: C
                    })];
                    if (cell && cell.v) {
                        let cellValue = cell.v.toString();
                        let cellWidth = cellValue.length;
                        if (cellWidth > maxWidth) {
                            maxWidth = cellWidth;
                        }
                    }
                }
                colWidths.push({
                    wch: maxWidth
                });
            }
            ws['!cols'] = colWidths;

            XLSX.utils.book_append_sheet(wb, ws, "Customer Wise Bill");

            XLSX.writeFile(wb, "customer-wise-bill.xlsx");
        }
    </script>
@endsection
