@extends('layouts.app')
@section('title')
    Settings
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Settings</h4>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0">

                    <form action="{{ route('settings.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="row">
                            <div class="col-lg-4 col-sm-6 col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="mb-0 text-primary">Logo Light</h5>
                                    </div>
                                    <div class="card-body pt-0">
                                        <div class="setting-card">
                                            <div class="logo-content mt-4">
                                                <img id="logo_light_image"
                                                    src="{{ !empty($settings['company_logo_light']) ? asset('storage/logo/' . $settings['company_logo_light']) : asset('images/placeholder.png') }}"
                                                    class="big-logo light-logo">
                                            </div>
                                            <div class="choose-files mt-5 text-center">
                                                <label for="company_logo_light">
                                                    <div class="bg-primary py-2 px-3 rounded text-white cursor-pointer"> <i
                                                            class="fa fa-upload mr-2"></i>Choose file here</div>
                                                    <input type="file" name="company_logo_light" id="company_logo_light"
                                                        class="form-control file" accept="image/*">
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-4 col-sm-6 col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="mb-0 text-primary">Logo dark</h5>
                                    </div>
                                    <div class="card-body pt-0">
                                        <div class="setting-card">
                                            <div class="logo-content mt-4">
                                                <img id="logo_dark_image"
                                                    src="{{ !empty($settings['company_logo_dark']) ? asset('storage/logo/' . $settings['company_logo_dark']) : asset('images/placeholder.png') }}"
                                                    class="big-logo">
                                            </div>
                                            <div class="choose-files mt-5 text-center">
                                                <label for="company_logo_dark">
                                                    <div class="bg-primary py-2 px-3 rounded text-white cursor-pointer"> <i
                                                            class="fa fa-upload mr-2"></i>Choose file here</div>
                                                    <input type="file" name="company_logo_dark" id="company_logo_dark"
                                                        class="form-control file" accept="image/*">
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-4 col-sm-6 col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="mb-0 text-primary">Favicon</h5>
                                    </div>
                                    <div class="card-body pt-0">
                                        <div class="setting-card">
                                            <div class="logo-content mt-4">
                                                <img id="favicon_image"
                                                    src="{{ !empty($settings['company_favicon']) ? asset('storage/logo/' . $settings['company_favicon']) : asset('images/placeholder.png') }}"
                                                    class="big-logo">
                                            </div>
                                            <div class="choose-files mt-5 text-center">
                                                <label for="company_favicon">
                                                    <div class="bg-primary py-2 px-3 rounded text-white cursor-pointer"> <i
                                                            class="fa fa-upload mr-2"></i>Choose file here</div>
                                                    <input type="file" name="company_favicon" id="company_favicon"
                                                        class="form-control file" accept="image/*">
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <h5 class="text-primary">Company Settings</h5>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="company_name">Company Name :</label>
                                    <input type="text" id="company_name" class="form-control" name="company_name"
                                        value="{{ $settings['company_name'] }}" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="app_name">App Name :</label>
                                    <input type="text" id="app_name" class="form-control" name="app_name"
                                        value="{{ $settings['app_name'] }}" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="company_address">Company Address :</label>
                                    <input type="text" id="company_address" class="form-control" name="company_address"
                                        value="{{ $settings['company_address'] }}" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="company_city">Company City :</label>
                                    <input type="text" id="company_city" class="form-control" name="company_city"
                                        value="{{ $settings['company_city'] }}" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="company_zip">Zip/Post Code :</label>
                                    <input type="text" id="company_zip" class="form-control" name="company_zip"
                                        value="{{ $settings['company_zip'] }}" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="company_country">Country :</label>
                                    <input type="text" id="company_country" class="form-control"
                                        name="company_country" value="{{ $settings['company_country'] }}" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="company_bin">BIN :</label>
                                    <input type="text" id="company_bin" class="form-control" name="company_bin"
                                        value="{{ $settings['company_bin'] }}" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="company_tin">TIN :</label>
                                    <input type="text" id="company_tin" class="form-control"
                                        name="company_tin" value="{{ $settings['company_tin'] }}" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <hr>
                                    <h5 class="text-primary">Currency Settings</h5>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="currency">Currency :</label>
                                    <input type="text" id="currency" class="form-control" name="currency"
                                        value="{{ $settings['currency'] }}" />
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="currency_symbol">Currency Symbol :</label>
                                    <input type="text" id="currency_symbol" class="form-control"
                                        name="currency_symbol" value="{{ $settings['currency_symbol'] }}" />
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="currency_symbol">Decimal Number Format :</label>
                                    <input type="text" id="decimal_number" class="form-control" name="decimal_number"
                                        value="{{ $settings['decimal_number'] }}" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <hr>
                                    <h5 class="text-primary">Bank Settings</h5>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bank_account_name">Account Name :</label>
                                    <input type="text" id="bank_account_name" class="form-control" name="bank_account_name"
                                        value="{{ $settings['bank_account_name'] }}" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bank_account_no">Account No :</label>
                                    <input type="text" id="bank_account_no" class="form-control"
                                        name="bank_account_no" value="{{ $settings['bank_account_no'] }}" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bank_name">Bank Name :</label>
                                    <input type="text" id="bank_name" class="form-control" name="bank_name"
                                        value="{{ $settings['bank_name'] }}" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="branch_name">Branch Name :</label>
                                    <input type="text" id="branch_name" class="form-control"
                                        name="branch_name" value="{{ $settings['branch_name'] }}" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="routing_no">Routing No :</label>
                                    <input type="text" id="routing_no" class="form-control" name="routing_no"
                                        value="{{ $settings['routing_no'] }}" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="swift_code">Swift Code :</label>
                                    <input type="text" id="swift_code" class="form-control" name="swift_code"
                                        value="{{ $settings['swift_code'] }}" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <br />
                                <a href="{{ route('dashboard') }}" class="btn btn-info">Cancel</a>
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    </div>

    <script>
        document.getElementById('company_logo_light').onchange = function() {
            var src = URL.createObjectURL(this.files[0])
            document.getElementById('logo_light_image').src = src
        }
        document.getElementById('company_logo_dark').onchange = function() {
            var src = URL.createObjectURL(this.files[0])
            document.getElementById('logo_dark_image').src = src
        }
        document.getElementById('company_favicon').onchange = function() {
            var src = URL.createObjectURL(this.files[0])
            document.getElementById('favicon_image').src = src
        }
    </script>
@endsection
