@extends('layouts.app')
@section('title')
    User Create
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">User Create</h4>
        </div>
        <div class="col-md-6 text-right">
            <a href="{{ route('users.index') }}" class="btn btn-primary">Users</a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_title">
                    <h5>User Entry</h5>
                    <div class="clearfix"></div>
                </div>
                <div class="x_content" style="padding:0">
                    <form action="{{ route('users.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">Name* :</label>
                                    <input type="text" id="name" class="form-control" name="name"
                                        value="{{ old('name') }}" required />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="employee_id">Employee ID :</label>
                                    <input type="number" id="employee_id" class="form-control" name="employee_id"
                                        value="{{ old('employee_id') }}" autocomplete="off" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="email">Email* :</label>
                                    <input type="email" id="email" class="form-control" name="email"
                                        autocomplete="off" value="{{ old('email') }}" required />
                                    @error('email')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="password">Password* :</label>
                                    <input type="password" id="password" class="form-control" name="password"
                                        autocomplete="off" value="{{ old('password') }}" required />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="phone">Phone :</label>
                                    <input type="number" id="phone" class="form-control" name="phone" value="{{ old('phone') }}" oninput="this.value = this.value.slice(0, 11)" autocomplete="off" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="roles">Role :</label>
                                    <select name="roles[]" id="roles" class="form-control select2">
                                        <option value="">-- Select Role --</option>
                                        @foreach ($roles as $role)
                                            <option value="{{ $role->name }}">{{ $role->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="address">Address :</label>
                                    <textarea id="address" class="form-control" name="address" rows="3" maxlength="500" autocomplete="off">{{ old('address') }}</textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <br />
                                <a href="{{ route('users.index') }}" class="btn btn-info">Cancel</a>
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
