<form action="{{ route('user-dept.update', $UserDept->id) }}" method="POST" autocomplete="off">
    @csrf
    @method('PATCH')

    <div class="modal-body">
        <div class="row">
            <div class="col-12">
                <div class="form-group">
                    <label for="user_id">User* :</label>
                    <select id="user_id" name="user_id" class="form-control select2" required>
                        <option value="">--Select User--</option>
                        @foreach ($users as $row)
                        <option value="{{$row->id}}"
                            {{($row->id==$UserDept->user_id)? 'selected':''}}>{{$row->name}}</option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="department_id">Department* :</label>
                    <select id="department_id" name="department_id" class="form-control select2" required>
                        <option value="">--Select Department--</option>
                        @foreach ($departments as $row)
                        @if($row['divCode']!='000')
                        <option value="{{$row['divCode']}}"
                            {{($row['divCode']==$UserDept->department_id)? 'selected':''}}>{{$row['divName']}}</option>
                        @endif
                        @endforeach
                    </select>
                    <input type="hidden" id="billDivName" name="billDivName" value="{{$UserDept->billDivName}}">
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <input type="button" value="{{ __('Cancel') }}" class="btn btn-danger" data-dismiss="modal">
        <input type="submit" value="{{ __('Update') }}" class="btn btn-primary">
    </div>
</form>

<script>
    $('#department_id').change(function(){
        var selOption = $(this).children('option:selected');
        var selText = selOption.text();
        $('#billDivName').val(selText);
    });
    $('.select2').select2({
        dropdownParent: $('#commonModal')
    });
</script>
