
@if ($paginator->hasPages())
  <nav>
      <ul class="pagination mb-0">
          {{-- Previous Page Link --}}
          <li class="page-item {{ $paginator->onFirstPage() ? 'disabled' : '' }}">
              <a class="page-link" href="{{ $paginator->previousPageUrl() }}" rel="prev">Previous</a>
          </li>

          {{-- Page Numbers --}}
          @php
              $currentPage = $paginator->currentPage();
              $totalPages = $paginator->lastPage();
              $pagesToShow = 3;
              
              // Determine the start page for the current set
              $startPage = floor(($currentPage - 1) / $pagesToShow) * $pagesToShow + 1;
              // Determine the end page for the current set
              $endPage = min($startPage + $pagesToShow - 1, $totalPages);
              
              // Adjust startPage if endPage is too close to the end
              if ($endPage - $startPage < $pagesToShow - 1) {
                  $startPage = max(1, $endPage - $pagesToShow + 1);
              }
          @endphp

          @for ($page = $startPage; $page <= $endPage; $page++)
              <li class="page-item {{ $page == $currentPage ? 'active' : '' }}">
                  <a class="page-link" href="{{ $paginator->url($page) }}">{{ $page }}</a>
              </li>
          @endfor

          {{-- Next Page Link --}}
          <li class="page-item {{ !$paginator->hasMorePages() ? 'disabled' : '' }}">
              <a class="page-link" href="{{ $paginator->nextPageUrl() }}" rel="next">Next</a>
          </li>
      </ul>
  </nav>
@endif

<style>
  .pagination {
    margin-bottom: 0;
  }
  
  .page-item.disabled .page-link {
    cursor: not-allowed;
  }
  
  .page-item.active .page-link {
    background-color: #007bff;
    border-color: #007bff;
  }
  
  .page-link {
    color: #007bff;
  }
  
  .page-link:hover {
    color: #0056b3;
    text-decoration: none;
  }
</style>
